/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.popup;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.widget.PopupWindowCompat;
import com.usercentrics.sdk.models.settings.PredefinedUILanguage;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.components.UCTextView;
import com.usercentrics.sdk.ui.extensions.NumberExtensionsKt;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\nH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001bH\u0002J\b\u0010(\u001a\u00020\nH\u0016J\u001a\u0010)\u001a\u00020\u00002\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ\u001e\u0010+\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0003J$\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/usercentrics/sdk/ui/popup/LanguagePopup;", "Landroid/widget/PopupWindow$OnDismissListener;", "context", "Landroid/content/Context;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "(Landroid/content/Context;Lcom/usercentrics/sdk/ui/theme/UCThemeData;)V", "languageSelectedListener", "Lkotlin/Function1;", "", "", "popupWindow", "Landroid/widget/PopupWindow;", "regularPadding", "", "getRegularPadding", "()I", "smallPadding", "getSmallPadding", "addLanguages", "container", "Landroid/view/ViewGroup;", "languages", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUILanguage;", "selectedIsoCode", "buildContentView", "Landroid/view/View;", "containerBackground", "Landroid/graphics/drawable/Drawable;", "dismiss", "handleDismiss", "languageTextView", "Landroid/widget/TextView;", "language", "bottomPadding", "isSelected", "", "languageTextViewClickListener", "view", "onDismiss", "setLanguageSelectedListener", "listener", "setupWindow", "show", "anchor", "usercentrics-ui_release"})
public final class LanguagePopup
implements PopupWindow.OnDismissListener {
    @NotNull
    private final Context context;
    @NotNull
    private final UCThemeData theme;
    @NotNull
    private final PopupWindow popupWindow;
    @Nullable
    private Function1<? super String, Unit> languageSelectedListener;

    public LanguagePopup(@NotNull Context context, @NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.context = context;
        this.theme = theme;
        this.popupWindow = new PopupWindow();
    }

    private final int getSmallPadding() {
        return NumberExtensionsKt.dpToPx(8, this.context);
    }

    private final int getRegularPadding() {
        return NumberExtensionsKt.dpToPx(16, this.context);
    }

    public final void show(@NotNull View anchor, @NotNull List<PredefinedUILanguage> languages, @NotNull String selectedIsoCode) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)selectedIsoCode, (String)"selectedIsoCode");
        this.setupWindow(languages, selectedIsoCode);
        PopupWindowCompat.showAsDropDown((PopupWindow)this.popupWindow, (View)anchor, (int)anchor.getWidth(), (int)0, (int)0);
    }

    @NotNull
    public final LanguagePopup setLanguageSelectedListener(@NotNull Function1<? super String, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.languageSelectedListener = listener2;
        return this;
    }

    public void onDismiss() {
        this.handleDismiss();
    }

    @SuppressLint(value={"InflateParams"})
    private final void setupWindow(List<PredefinedUILanguage> languages, String selectedIsoCode) {
        PopupWindow popupWindow;
        PopupWindow $this$setupWindow_u24lambda_u240 = popupWindow = this.popupWindow;
        boolean bl = false;
        $this$setupWindow_u24lambda_u240.setContentView(this.buildContentView(languages, selectedIsoCode));
        $this$setupWindow_u24lambda_u240.setWidth(NumberExtensionsKt.dpToPx(200, this.context));
        $this$setupWindow_u24lambda_u240.setHeight(-2);
        $this$setupWindow_u24lambda_u240.setInputMethodMode(0);
        $this$setupWindow_u24lambda_u240.setSoftInputMode(1);
        $this$setupWindow_u24lambda_u240.setFocusable(true);
        $this$setupWindow_u24lambda_u240.setOutsideTouchable(true);
        $this$setupWindow_u24lambda_u240.setOnDismissListener((PopupWindow.OnDismissListener)this);
        $this$setupWindow_u24lambda_u240.setElevation(NumberExtensionsKt.dpToPx(12.0f, this.context));
        $this$setupWindow_u24lambda_u240.setBackgroundDrawable(this.containerBackground());
    }

    private final View buildContentView(List<PredefinedUILanguage> languages, String selectedIsoCode) {
        LinearLayout linearLayout;
        ScrollView scrollView2;
        ScrollView $this$buildContentView_u24lambda_u242 = scrollView2 = new ScrollView(this.context);
        boolean bl = false;
        LinearLayout $this$buildContentView_u24lambda_u242_u24lambda_u241 = linearLayout = new LinearLayout($this$buildContentView_u24lambda_u242.getContext());
        boolean bl2 = false;
        $this$buildContentView_u24lambda_u242_u24lambda_u241.setId(R.id.ucLanguagesAvailable);
        $this$buildContentView_u24lambda_u242_u24lambda_u241.setOrientation(1);
        $this$buildContentView_u24lambda_u242_u24lambda_u241.setPadding(this.getSmallPadding(), this.getRegularPadding(), this.getSmallPadding(), this.getRegularPadding());
        this.addLanguages((ViewGroup)$this$buildContentView_u24lambda_u242_u24lambda_u241, languages, selectedIsoCode);
        LinearLayout container = linearLayout;
        $this$buildContentView_u24lambda_u242.addView((View)container);
        return (View)scrollView2;
    }

    private final Drawable containerBackground() {
        GradientDrawable gradientDrawable;
        GradientDrawable $this$containerBackground_u24lambda_u243 = gradientDrawable = new GradientDrawable();
        boolean bl = false;
        $this$containerBackground_u24lambda_u243.setCornerRadius(NumberExtensionsKt.dpToPx(4.0f, this.context));
        Integer n = this.theme.getColorPalette().getLayerBackgroundColor();
        $this$containerBackground_u24lambda_u243.setColor(n != null ? n : -1);
        $this$containerBackground_u24lambda_u243.setStroke(NumberExtensionsKt.dpToPx(1, this.context), this.theme.getColorPalette().getTabsBorderColor());
        return (Drawable)gradientDrawable;
    }

    private final void addLanguages(ViewGroup container, List<PredefinedUILanguage> languages, String selectedIsoCode) {
        boolean hasNext;
        Iterator<PredefinedUILanguage> iterator = languages.iterator();
        do {
            PredefinedUILanguage language = iterator.next();
            hasNext = iterator.hasNext();
            int bottomPadding = hasNext ? this.getRegularPadding() : this.getSmallPadding();
            boolean isSelected = Intrinsics.areEqual((Object)selectedIsoCode, (Object)language.getIsoCode());
            TextView textView = this.languageTextView(language, bottomPadding, isSelected);
            container.addView((View)textView);
        } while (hasNext);
    }

    private final TextView languageTextView(PredefinedUILanguage language, int bottomPadding, boolean isSelected) {
        UCTextView uCTextView;
        UCTextView $this$languageTextView_u24lambda_u244 = uCTextView = new UCTextView(this.context);
        boolean bl = false;
        $this$languageTextView_u24lambda_u244.setTextSize(16.0f);
        $this$languageTextView_u24lambda_u244.setText(language.getFullName());
        $this$languageTextView_u24lambda_u244.setTag(language.getIsoCode());
        $this$languageTextView_u24lambda_u244.setPadding(this.getSmallPadding(), this.getSmallPadding(), this.getSmallPadding(), bottomPadding);
        Integer n = this.theme.getColorPalette().getText100();
        $this$languageTextView_u24lambda_u244.setTextColor(n != null ? n : ContextCompat.getColor((Context)$this$languageTextView_u24lambda_u244.getContext(), (int)R.color.ucDarkGray));
        $this$languageTextView_u24lambda_u244.setOnClickListener(this::languageTextViewClickListener);
        int style2 = isSelected ? 1 : 0;
        $this$languageTextView_u24lambda_u244.setTypeface(this.theme.getFonts().getFont(), style2);
        return (TextView)uCTextView;
    }

    private final void languageTextViewClickListener(View view) {
        block1: {
            this.dismiss();
            Object object = view.getTag();
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                return;
            }
            String languageIsoCode = string;
            Function1<? super String, Unit> function1 = this.languageSelectedListener;
            if (function1 == null) break block1;
            function1.invoke((Object)languageIsoCode);
        }
    }

    private final void dismiss() {
        this.popupWindow.dismiss();
    }

    private final void handleDismiss() {
        if (this.popupWindow.isShowing()) {
            this.dismiss();
        }
    }
}

