/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.logger;

import com.usercentrics.sdk.errors.UsercentricsError;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.UsercentricsLoggerLevel;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/usercentrics/sdk/logger/UsercentricsUILoggerImpl;", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "level", "Lcom/usercentrics/sdk/models/common/UsercentricsLoggerLevel;", "(Lcom/usercentrics/sdk/models/common/UsercentricsLoggerLevel;)V", "appendCause", "", "cause", "", "debug", "", "message", "error", "warning", "write", "targetLevel", "Companion", "usercentrics-ui_release"})
public final class UsercentricsUILoggerImpl
implements UsercentricsLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsLoggerLevel level;
    @NotNull
    private static final String PREFIX = "[USERCENTRICS_UI]";

    public UsercentricsUILoggerImpl(@NotNull UsercentricsLoggerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.level = level;
    }

    public void debug(@NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level == UsercentricsLoggerLevel.DEBUG) {
            this.write(UsercentricsLoggerLevel.DEBUG, message, cause);
        }
    }

    public void warning(@NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level.ordinal() >= UsercentricsLoggerLevel.WARNING.ordinal()) {
            this.write(UsercentricsLoggerLevel.WARNING, message, cause);
        }
    }

    public void error(@NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level.ordinal() >= UsercentricsLoggerLevel.ERROR.ordinal()) {
            this.write(UsercentricsLoggerLevel.ERROR, message, cause);
        }
    }

    private final void write(UsercentricsLoggerLevel targetLevel, String message, Throwable cause) {
        System.out.println((Object)("[USERCENTRICS_UI][" + targetLevel.name() + "] " + message + this.appendCause(cause)));
    }

    private final String appendCause(Throwable cause) {
        return cause != null ? " | cause: " + ExceptionsKt.stackTraceToString((Throwable)cause) : "";
    }

    public void error(@NotNull UsercentricsError error) {
        UsercentricsLogger.DefaultImpls.error((UsercentricsLogger)this, (UsercentricsError)error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/logger/UsercentricsUILoggerImpl$Companion;", "", "()V", "PREFIX", "", "usercentrics-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

