/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.banner;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.transition.Fade;
import androidx.transition.Slide;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.usercentrics.sdk.ui.banner.BannerTransitionParameters;
import com.usercentrics.sdk.ui.banner.UCBannerContainerView;
import com.usercentrics.sdk.ui.banner.UCBannerTransition;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0016J\"\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010 H\u0002J\u0016\u0010$\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002R\u0016\u0010\r\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/usercentrics/sdk/ui/banner/UCBannerTransitionImpl;", "Lcom/usercentrics/sdk/ui/banner/UCBannerTransition;", "context", "Landroid/content/Context;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "customOverlayColor", "", "bannerContainerView", "Lcom/usercentrics/sdk/ui/banner/UCBannerContainerView;", "slideTransitionEnabled", "", "(Landroid/content/Context;Lcom/usercentrics/sdk/ui/theme/UCThemeData;Ljava/lang/Integer;Lcom/usercentrics/sdk/ui/banner/UCBannerContainerView;Z)V", "backgroundOverlayColor", "getBackgroundOverlayColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "dialogBackgroundView", "Landroid/widget/FrameLayout;", "getDialogBackgroundView", "()Landroid/widget/FrameLayout;", "dialogBackgroundView$delegate", "Lkotlin/Lazy;", "rootView", "Landroid/view/View;", "getRootView", "()Landroid/view/View;", "rootView$delegate", "enter", "", "exit", "callback", "Lkotlin/Function0;", "slideDialog", "parameters", "Lcom/usercentrics/sdk/ui/banner/BannerTransitionParameters;", "slideDialogDown", "slideDialogUp", "Companion", "usercentrics-ui_release"})
public final class UCBannerTransitionImpl
implements UCBannerTransition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final UCThemeData theme;
    @Nullable
    private final Integer customOverlayColor;
    @NotNull
    private UCBannerContainerView bannerContainerView;
    private final boolean slideTransitionEnabled;
    @NotNull
    private final Lazy dialogBackgroundView$delegate;
    @NotNull
    private final Lazy rootView$delegate;
    private static final long defaultAnimationDuration = 300L;

    public UCBannerTransitionImpl(@NotNull Context context, @NotNull UCThemeData theme, @ColorInt @Nullable Integer customOverlayColor, @NotNull UCBannerContainerView bannerContainerView, boolean slideTransitionEnabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)bannerContainerView, (String)"bannerContainerView");
        this.context = context;
        this.theme = theme;
        this.customOverlayColor = customOverlayColor;
        this.bannerContainerView = bannerContainerView;
        this.slideTransitionEnabled = slideTransitionEnabled;
        this.dialogBackgroundView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FrameLayout>(this){
            final /* synthetic */ UCBannerTransitionImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FrameLayout invoke() {
                FrameLayout frameLayout;
                block0: {
                    frameLayout = new FrameLayout(UCBannerTransitionImpl.access$getContext$p(this.this$0));
                    UCBannerTransitionImpl uCBannerTransitionImpl = this.this$0;
                    FrameLayout $this$invoke_u24lambda_u241 = frameLayout;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setVisibility(4);
                    $this$invoke_u24lambda_u241.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    $this$invoke_u24lambda_u241.addView((View)UCBannerTransitionImpl.access$getBannerContainerView$p(uCBannerTransitionImpl));
                    Integer n = UCBannerTransitionImpl.access$getBackgroundOverlayColor(uCBannerTransitionImpl);
                    if (n == null) break block0;
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241.setBackgroundColor(it);
                }
                return frameLayout;
            }
        }));
        this.rootView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FrameLayout>(this){
            final /* synthetic */ UCBannerTransitionImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FrameLayout invoke() {
                return UCBannerTransitionImpl.access$getDialogBackgroundView(this.this$0);
            }
        }));
    }

    private final Integer getBackgroundOverlayColor() {
        Integer n = this.customOverlayColor;
        if (n == null) {
            n = this.theme.getColorPalette().getOverlayColor();
        }
        return n;
    }

    private final FrameLayout getDialogBackgroundView() {
        Lazy lazy = this.dialogBackgroundView$delegate;
        return (FrameLayout)lazy.getValue();
    }

    @Override
    @NotNull
    public View getRootView() {
        Lazy lazy = this.rootView$delegate;
        return (View)lazy.getValue();
    }

    @Override
    public void enter() {
        if (this.slideTransitionEnabled) {
            this.slideDialogUp();
        } else {
            this.getDialogBackgroundView().setVisibility(0);
            this.bannerContainerView.setVisibility(0);
        }
    }

    @Override
    public void exit(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.slideTransitionEnabled) {
            this.slideDialogDown(callback);
        } else {
            callback.invoke();
        }
    }

    private final void slideDialogUp() {
        new Handler(Looper.getMainLooper()).post(() -> UCBannerTransitionImpl.slideDialogUp$lambda$0(this));
    }

    private final void slideDialogDown(Function0<Unit> callback) {
        this.slideDialog(BannerTransitionParameters.SlideDown.INSTANCE, callback);
    }

    private final void slideDialog(BannerTransitionParameters parameters, Function0<Unit> callback) {
        Fade fade;
        Slide slide;
        Slide $this$slideDialog_u24lambda_u241 = slide = new Slide(parameters.getGravity());
        boolean bl = false;
        $this$slideDialog_u24lambda_u241.setDuration(300L);
        $this$slideDialog_u24lambda_u241.addTarget((View)this.bannerContainerView);
        Slide slideTransition = slide;
        UCBannerContainerView uCBannerContainerView = this.bannerContainerView;
        Intrinsics.checkNotNull((Object)uCBannerContainerView, (String)"null cannot be cast to non-null type android.view.ViewGroup");
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)uCBannerContainerView), (Transition)((Transition)slideTransition));
        this.bannerContainerView.setVisibility(parameters.getVisibility());
        Fade $this$slideDialog_u24lambda_u242 = fade = new Fade(parameters.getFadingMode());
        boolean bl2 = false;
        $this$slideDialog_u24lambda_u242.setDuration(300L);
        $this$slideDialog_u24lambda_u242.addTarget((View)this.getDialogBackgroundView());
        Fade fadeTransition = fade;
        if (callback != null) {
            fadeTransition.addListener(new Transition.TransitionListener(callback){
                final /* synthetic */ Function0<Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onTransitionEnd(@NotNull Transition transition) {
                    Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
                    this.$callback.invoke();
                }

                public void onTransitionStart(@NotNull Transition transition) {
                    Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
                }

                public void onTransitionCancel(@NotNull Transition transition) {
                    Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
                }

                public void onTransitionPause(@NotNull Transition transition) {
                    Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
                }

                public void onTransitionResume(@NotNull Transition transition) {
                    Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
                }
            });
        }
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)this.getDialogBackgroundView()), (Transition)((Transition)fadeTransition));
        this.getDialogBackgroundView().setVisibility(parameters.getVisibility());
    }

    static /* synthetic */ void slideDialog$default(UCBannerTransitionImpl uCBannerTransitionImpl, BannerTransitionParameters bannerTransitionParameters, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        uCBannerTransitionImpl.slideDialog(bannerTransitionParameters, (Function0<Unit>)function0);
    }

    private static final void slideDialogUp$lambda$0(UCBannerTransitionImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        UCBannerTransitionImpl.slideDialog$default(this$0, BannerTransitionParameters.SlideUp.INSTANCE, null, 2, null);
    }

    public static final /* synthetic */ Context access$getContext$p(UCBannerTransitionImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ UCBannerContainerView access$getBannerContainerView$p(UCBannerTransitionImpl $this) {
        return $this.bannerContainerView;
    }

    public static final /* synthetic */ Integer access$getBackgroundOverlayColor(UCBannerTransitionImpl $this) {
        return $this.getBackgroundOverlayColor();
    }

    public static final /* synthetic */ FrameLayout access$getDialogBackgroundView(UCBannerTransitionImpl $this) {
        return $this.getDialogBackgroundView();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/ui/banner/UCBannerTransitionImpl$Companion;", "", "()V", "defaultAnimationDuration", "", "usercentrics-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

