/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.extensions;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import androidx.appcompat.view.ContextThemeWrapper;
import com.usercentrics.sdk.ui.PredefinedUIDependencyManager;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.extensions.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0000\u001a\f\u0010\n\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\bH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\f*\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"inflater", "Landroid/view/LayoutInflater;", "Landroid/content/Context;", "getInflater", "(Landroid/content/Context;)Landroid/view/LayoutInflater;", "copyToClipboard", "", "text", "", "clipboardLabel", "isActivityFinishingOrDestroyed", "openUrl", "", "url", "safeShowBanner", "showBannerHandler", "Lkotlin/Function0;", "themed", "usercentrics-ui_release"})
@SourceDebugExtension(value={"SMAP\nContextExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextExtensions.kt\ncom/usercentrics/sdk/ui/extensions/ContextExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class ContextExtensionsKt {
    @NotNull
    public static final LayoutInflater getInflater(@NotNull Context $this$inflater) {
        Intrinsics.checkNotNullParameter((Object)$this$inflater, (String)"<this>");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(...)");
        return layoutInflater;
    }

    public static final boolean copyToClipboard(@NotNull Context $this$copyToClipboard, @NotNull String text, @NotNull String clipboardLabel) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$copyToClipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)clipboardLabel, (String)"clipboardLabel");
        try {
            Object object = $this$copyToClipboard.getSystemService("clipboard");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
            ClipboardManager clipboard = (ClipboardManager)object;
            ClipData clip = ClipData.newPlainText((CharSequence)clipboardLabel, (CharSequence)text);
            clipboard.setPrimaryClip(clip);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean copyToClipboard$default(Context context, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return ContextExtensionsKt.copyToClipboard(context, string, string2);
    }

    @NotNull
    public static final Context themed(@NotNull Context $this$themed) {
        Intrinsics.checkNotNullParameter((Object)$this$themed, (String)"<this>");
        return (Context)new ContextThemeWrapper($this$themed, R.style.BaseTheme);
    }

    public static final void openUrl(@NotNull Context $this$openUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$openUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            boolean bl;
            boolean bl2 = bl = !StringsKt.isBlank((CharSequence)url);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Empty URL";
                throw new AssertionError((Object)string);
            }
            $this$openUrl.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)StringExtensionsKt.addHttpsIfNeeded(url))).putExtra("com.android.browser.application_id", $this$openUrl.getPackageName()));
        }
        catch (Throwable e) {
            PredefinedUIDependencyManager.INSTANCE.getLogger().error("Error when opening URL<" + url + '>', e);
        }
    }

    public static final void safeShowBanner(@NotNull Context $this$safeShowBanner, @NotNull Function0<Unit> showBannerHandler) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$safeShowBanner, (String)"<this>");
            Intrinsics.checkNotNullParameter(showBannerHandler, (String)"showBannerHandler");
            if (ContextExtensionsKt.isActivityFinishingOrDestroyed($this$safeShowBanner)) {
                return;
            }
            try {
                showBannerHandler.invoke();
            }
            catch (Exception cause) {
                String string;
                if (!_Assertions.ENABLED) break block3;
                boolean bl = false;
                String it = string = "Show Banner Error: " + cause;
                boolean bl2 = false;
                cause.printStackTrace();
                String string2 = string;
                throw new AssertionError((Object)string2);
            }
        }
    }

    public static final boolean isActivityFinishingOrDestroyed(@NotNull Context $this$isActivityFinishingOrDestroyed) {
        Intrinsics.checkNotNullParameter((Object)$this$isActivityFinishingOrDestroyed, (String)"<this>");
        Activity activity = $this$isActivityFinishingOrDestroyed instanceof Activity ? (Activity)$this$isActivityFinishingOrDestroyed : null;
        return activity == null || activity.isFinishing() || activity.isDestroyed();
    }
}

