/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.mappers;

import com.usercentrics.sdk.models.settings.PredefinedUICardContent;
import com.usercentrics.sdk.models.settings.PredefinedUICardUI;
import com.usercentrics.sdk.models.settings.PredefinedUIHyperlinkServiceContent;
import com.usercentrics.sdk.models.settings.PredefinedUILabels;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceContent;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceContentSection;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceDetails;
import com.usercentrics.sdk.models.settings.PredefinedUISimpleCardContent;
import com.usercentrics.sdk.models.settings.PredefinedUISimpleServiceContent;
import com.usercentrics.sdk.models.settings.PredefinedUISingleServiceCardContent;
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationButtonInfo;
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationServiceContent;
import com.usercentrics.sdk.models.settings.PredefinedUISwitchSettingsUI;
import com.usercentrics.sdk.ui.components.UCTogglePM;
import com.usercentrics.sdk.ui.components.cards.UCCardPM;
import com.usercentrics.sdk.ui.components.cards.UCContentSectionPM;
import com.usercentrics.sdk.ui.components.cards.UCContentTextSectionPM;
import com.usercentrics.sdk.ui.components.links.UCLinkPMLegacy;
import com.usercentrics.sdk.ui.mappers.UCServiceMapper;
import com.usercentrics.sdk.ui.mappers.UCServiceSectionMapper;
import com.usercentrics.sdk.ui.toggle.PredefinedUIToggleGroup;
import com.usercentrics.sdk.ui.toggle.PredefinedUIToggleMediator;
import com.usercentrics.sdk.v2.settings.data.DpsDisplayFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J*\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/usercentrics/sdk/ui/mappers/UCServiceMapperImpl;", "Lcom/usercentrics/sdk/ui/mappers/UCServiceMapper;", "onOpenUrl", "Lkotlin/Function1;", "", "", "onShowCookiesDialog", "Lcom/usercentrics/sdk/models/settings/PredefinedUIStorageInformationButtonInfo;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "sectionMapper", "Lcom/usercentrics/sdk/ui/mappers/UCServiceSectionMapper;", "contentSectionsFrom", "", "Lcom/usercentrics/sdk/ui/components/cards/UCContentSectionPM;", "serviceDetails", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceDetails;", "labels", "Lcom/usercentrics/sdk/models/settings/PredefinedUILabels;", "serviceContentSection", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceContentSection;", "createServiceCard", "Lcom/usercentrics/sdk/ui/components/cards/UCCardPM;", "service", "Lcom/usercentrics/sdk/models/settings/PredefinedUICardUI;", "mainGroup", "Lcom/usercentrics/sdk/ui/toggle/PredefinedUIToggleGroup;", "toggleMediator", "Lcom/usercentrics/sdk/ui/toggle/PredefinedUIToggleMediator;", "createSimpleCard", "predefinedCardUi", "map", "usercentrics-ui_release"})
@SourceDebugExtension(value={"SMAP\nUCServiceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UCServiceMapper.kt\ncom/usercentrics/sdk/ui/mappers/UCServiceMapperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1549#2:169\n1620#2,3:170\n1549#2:173\n1620#2,3:174\n*S KotlinDebug\n*F\n+ 1 UCServiceMapper.kt\ncom/usercentrics/sdk/ui/mappers/UCServiceMapperImpl\n*L\n66#1:169\n66#1:170,3\n141#1:173\n141#1:174,3\n*E\n"})
public final class UCServiceMapperImpl
implements UCServiceMapper {
    @NotNull
    private final UCServiceSectionMapper sectionMapper;

    public UCServiceMapperImpl(@NotNull Function1<? super String, Unit> onOpenUrl, @NotNull Function1<? super PredefinedUIStorageInformationButtonInfo, Unit> onShowCookiesDialog) {
        Intrinsics.checkNotNullParameter(onOpenUrl, (String)"onOpenUrl");
        Intrinsics.checkNotNullParameter(onShowCookiesDialog, (String)"onShowCookiesDialog");
        this.sectionMapper = new UCServiceSectionMapper(onOpenUrl, onShowCookiesDialog);
    }

    @Override
    @NotNull
    public UCCardPM map(@NotNull PredefinedUICardUI service, @Nullable PredefinedUIToggleGroup mainGroup, @NotNull PredefinedUIToggleMediator toggleMediator, @NotNull PredefinedUILabels labels) {
        UCCardPM uCCardPM;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)toggleMediator, (String)"toggleMediator");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        PredefinedUICardContent predefinedUICardContent = service.getContent();
        if (predefinedUICardContent instanceof PredefinedUISingleServiceCardContent) {
            uCCardPM = this.createServiceCard(service, labels, mainGroup, toggleMediator);
        } else if (predefinedUICardContent instanceof PredefinedUISimpleCardContent) {
            uCCardPM = this.createSimpleCard(service);
        } else {
            throw new NotImplementedError("Not supported card content");
        }
        return uCCardPM;
    }

    /*
     * WARNING - void declaration
     */
    private final UCCardPM createServiceCard(PredefinedUICardUI service, PredefinedUILabels labels, PredefinedUIToggleGroup mainGroup, PredefinedUIToggleMediator toggleMediator) {
        List list;
        PredefinedUICardContent predefinedUICardContent = service.getContent();
        Intrinsics.checkNotNull((Object)predefinedUICardContent, (String)"null cannot be cast to non-null type com.usercentrics.sdk.models.settings.PredefinedUISingleServiceCardContent");
        PredefinedUISingleServiceCardContent content2 = (PredefinedUISingleServiceCardContent)predefinedUICardContent;
        PredefinedUIServiceDetails serviceDetails = content2.getService();
        List serviceContentSection = serviceDetails.getServiceContentSection();
        List<UCContentSectionPM> contentSectionsPM = serviceContentSection != null ? this.contentSectionsFrom(serviceContentSection) : this.contentSectionsFrom(serviceDetails, labels);
        PredefinedUISwitchSettingsUI mainSwitchSettings = service.getMainSwitchSettings();
        UCTogglePM mainToggle = mainSwitchSettings != null ? new UCTogglePM(mainSwitchSettings, mainGroup) : null;
        List list2 = service.getSwitchSettings();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void itemSwitchSettings;
                PredefinedUISwitchSettingsUI predefinedUISwitchSettingsUI = (PredefinedUISwitchSettingsUI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PredefinedUIToggleGroup group = toggleMediator.getServiceGroupLegacy(service.getId(), (PredefinedUISwitchSettingsUI)itemSwitchSettings);
                collection.add(new UCTogglePM((PredefinedUISwitchSettingsUI)itemSwitchSettings, group));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List toggleList = list;
        return new UCCardPM(service.getId(), service.getTitle(), service.getShortDescription(), mainToggle, contentSectionsPM, toggleList);
    }

    private final UCCardPM createSimpleCard(PredefinedUICardUI predefinedCardUi) {
        PredefinedUICardContent predefinedUICardContent = predefinedCardUi.getContent();
        Intrinsics.checkNotNull((Object)predefinedUICardContent, (String)"null cannot be cast to non-null type com.usercentrics.sdk.models.settings.PredefinedUISimpleCardContent");
        String description = ((PredefinedUISimpleCardContent)predefinedUICardContent).getDescription();
        return new UCCardPM(predefinedCardUi.getId(), predefinedCardUi.getTitle(), predefinedCardUi.getShortDescription(), null, CollectionsKt.listOf((Object)new UCContentTextSectionPM(null, description, null, null, 12, null)), null);
    }

    private final List<UCContentSectionPM> contentSectionsFrom(PredefinedUIServiceDetails serviceDetails, PredefinedUILabels labels) {
        boolean shortDisplayFormat;
        PredefinedUIServiceContentSection storageInformationContentSection = serviceDetails.getStorageInformationContentSection();
        UCContentSectionPM storageInformation2 = storageInformationContentSection != null ? this.sectionMapper.storageInformation(storageInformationContentSection) : null;
        boolean bl = shortDisplayFormat = serviceDetails.getDpsDisplayFormat() != null && serviceDetails.getDpsDisplayFormat() == DpsDisplayFormat.SHORT;
        if (shortDisplayFormat) {
            Object[] objectArray = new UCContentSectionPM[]{this.sectionMapper.getServiceDescription(serviceDetails, labels), this.sectionMapper.getProcessingCompany(serviceDetails, labels), this.sectionMapper.getDataPurposes(serviceDetails, labels), this.sectionMapper.getDataCollected(serviceDetails, labels), this.sectionMapper.getDataRecipients(serviceDetails, labels), this.sectionMapper.getHistory(serviceDetails, labels)};
            return CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        Object[] objectArray = new UCContentSectionPM[]{this.sectionMapper.getServiceDescription(serviceDetails, labels), this.sectionMapper.getProcessingCompany(serviceDetails, labels), this.sectionMapper.getDataPurposes(serviceDetails, labels), this.sectionMapper.getTechnologiesUsed(serviceDetails, labels), this.sectionMapper.getDataCollected(serviceDetails, labels), this.sectionMapper.getLegalBasis(serviceDetails, labels), this.sectionMapper.getProcessingLocation(serviceDetails, labels), this.sectionMapper.getRetentionPeriod(serviceDetails, labels), this.sectionMapper.getThirdPartyCountriesDistribution(serviceDetails, labels), this.sectionMapper.getDataRecipients(serviceDetails, labels), this.sectionMapper.getPrivacyPolicy(serviceDetails, labels), this.sectionMapper.getCookiePolicy(serviceDetails, labels), this.sectionMapper.getOptOutLink(serviceDetails, labels), this.sectionMapper.getDataProcessingAgreement(serviceDetails, labels), storageInformation2, this.sectionMapper.getHistory(serviceDetails, labels)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UCContentSectionPM> contentSectionsFrom(List<PredefinedUIServiceContentSection> serviceContentSection) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = serviceContentSection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UCContentSectionPM uCContentSectionPM;
            void contentSection;
            PredefinedUIServiceContentSection predefinedUIServiceContentSection = (PredefinedUIServiceContentSection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PredefinedUIServiceContent serviceContent = contentSection.getContent();
            if (serviceContent instanceof PredefinedUISimpleServiceContent) {
                uCContentSectionPM = new UCContentTextSectionPM(contentSection.getTitle(), ((PredefinedUISimpleServiceContent)serviceContent).getContent(), null, null, 12, null);
            } else if (serviceContent instanceof PredefinedUIHyperlinkServiceContent) {
                String url = ((PredefinedUIHyperlinkServiceContent)serviceContent).getUrl();
                uCContentSectionPM = new UCContentTextSectionPM(contentSection.getTitle(), null, new UCLinkPMLegacy(url, this.sectionMapper.createUrlCallback(url)), null, 10, null);
            } else if (serviceContent instanceof PredefinedUIStorageInformationServiceContent) {
                uCContentSectionPM = this.sectionMapper.storageInformation((PredefinedUIServiceContentSection)contentSection);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(uCContentSectionPM);
        }
        return (List)destination$iv$iv;
    }
}

