package com.usercentrics.sdk

import android.graphics.Typeface
import androidx.annotation.ColorInt

sealed class ButtonLayout {
    data class Column(val buttons: List<ButtonSettings> = emptyList()) : ButtonLayout()
    data class Row(val buttons: List<ButtonSettings> = emptyList()) : ButtonLayout()
    data class Grid(val buttons: List<List<ButtonSettings>> = emptyList()) : ButtonLayout()
}

data class ButtonSettings(
    val type: ButtonType,
    val font: Typeface? = null,
    val textSizeInSp: Float? = null,
    @ColorInt val textColor: Int? = null,
    @ColorInt val backgroundColor: Int? = null,
    val cornerRadius: Int? = null,
    val isAllCaps: Boolean? = null,
)

enum class ButtonType {
    ACCEPT_ALL,
    DENY_ALL,
    MORE,
    SAVE
}
