package com.usercentrics.sdk.logger

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.models.common.UsercentricsLoggerLevel

internal class UsercentricsUILoggerImpl(
    private val level: UsercentricsLoggerLevel,
) : UsercentricsLogger {

    companion object {
        private const val PREFIX = "[USERCENTRICS_UI]"
    }

    override fun debug(message: String, cause: Throwable?) {
        if (level == UsercentricsLoggerLevel.DEBUG) {
            write(UsercentricsLoggerLevel.DEBUG, message, cause)
        }
    }

    override fun warning(message: String, cause: Throwable?) {
        if (level.ordinal >= UsercentricsLoggerLevel.WARNING.ordinal) {
            write(UsercentricsLoggerLevel.WARNING, message, cause)
        }
    }

    override fun error(message: String, cause: Throwable?) {
        if (level.ordinal >= UsercentricsLoggerLevel.ERROR.ordinal) {
            write(UsercentricsLoggerLevel.ERROR, message, cause)
        }
    }

    private fun write(targetLevel: UsercentricsLoggerLevel, message: String, cause: Throwable?) {
        println("$PREFIX[${targetLevel.name}] $message${appendCause(cause)}")
    }

    private fun appendCause(cause: Throwable?): String {
        return if (cause != null) {
            " | cause: ${cause.stackTraceToString()}"
        } else {
            ""
        }
    }
}
