package com.usercentrics.sdk.ui.accessibility

import android.graphics.Rect
import android.util.Log
import android.view.TouchDelegate
import android.view.View
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.extensions.dpToPx

internal fun View.createAccessibilityLinkOrButton() {
    minimumWidth = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLegalLinksOrButtonsMinimumWidth)
    minimumHeight = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLegalLinksOrButtonsMinimumHeight)
    isFocusable = true
}

internal fun View.accessibleTouchTarget() {
    post {
        val delegateArea = Rect()
        getHitRect(delegateArea)

        val accessibilityMin = context.dpToPx(48)

        val height = delegateArea.bottom - delegateArea.top
        if (accessibilityMin > height) {
            val addition = ((accessibilityMin - height) / 2).toInt() + 1
            delegateArea.top -= addition
            delegateArea.bottom += addition
        }

        val width = delegateArea.right - delegateArea.left
        if (accessibilityMin > width) {
            val addition = ((accessibilityMin - width) / 2).toInt() + 1
            delegateArea.left -= addition
            delegateArea.right += addition
        }

        val parentView = parent as? View

        if (parentView != null) {
            parentView.touchDelegate = TouchDelegate(delegateArea, this)
        }
    }
}
