package com.usercentrics.sdk.ui.components.cards

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.GradientDrawable
import android.graphics.drawable.InsetDrawable
import android.view.View
import android.view.ViewGroup
import android.widget.TableLayout
import com.google.android.flexbox.FlexboxLayout
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCImageView
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.components.drawable.ThemedDrawable.getNoHistoryIcon
import com.usercentrics.sdk.ui.components.drawable.ThemedDrawable.getYesHistoryIcon
import com.usercentrics.sdk.ui.extensions.dpToPx
import com.usercentrics.sdk.ui.extensions.inflater
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun buildHistorySectionView(context: Context, parent: ViewGroup, theme: UCThemeData, historySectionPM: UCContentHistorySectionPM): View {
    val colorPalette = theme.colorPalette

    val historySection = context.inflater.inflate(R.layout.uc_card_section_entry, parent, false)

    // Title
    val title = historySection.findViewById<UCTextView>(R.id.ucCardSectionEntryTitle)
    title.text = historySectionPM.title
    title.styleSmall(theme, isSecondary = true)

    // Description
    historySection.findViewById<UCTextView>(R.id.ucCardSectionEntryDescription).visibility = View.GONE

    val content = historySection.findViewById<FlexboxLayout>(R.id.ucCardSectionEntryFlexbox)

    // History
    val table = context.inflater.inflate(R.layout.uc_history_table, parent, false) as TableLayout
    val decisionRow = table.findViewById<View>(R.id.ucTableHeaderRow)
    val decisionHeader = table.findViewById<UCTextView>(R.id.ucTableDecisionHeader)
    val dateHeader = table.findViewById<UCTextView>(R.id.ucTableDateHeader)

    decisionRow.background = GradientDrawable().apply {
        shape = GradientDrawable.RECTANGLE
        cornerRadius = 2.dpToPx(context).toFloat()
        setStroke(1.dpToPx(context), colorPalette.tabsBorderColor)
        colorPalette.layerBackgroundColor?.let { setColor(it) }
    }

    decisionHeader.text = historySectionPM.decisionLabel
    dateHeader.text = historySectionPM.dateLabel

    decisionHeader.styleBody(theme)
    dateHeader.styleBody(theme)

    for (historyEntry in historySectionPM.history) {
        addHistoryEntry(context, table, theme, historySectionPM, historyEntry)
    }

    content.addView(table)

    return historySection
}

private fun addHistoryEntry(context: Context, table: TableLayout, theme: UCThemeData, historySection: UCContentHistorySectionPM, historyEntry: UCCardHistoryEntryPM) {
    val tableRow = context.inflater.inflate(R.layout.uc_history_table_row, table, false)

    val gradientDrawable = GradientDrawable().apply {
        shape = GradientDrawable.RECTANGLE
        setColor(Color.TRANSPARENT)
        cornerRadius = 2.dpToPx(context).toFloat()
        setStroke(1.dpToPx(context), theme.colorPalette.tabsBorderColor)
    }

    val insetTopBy = (-2).dpToPx(context)
    tableRow.background = InsetDrawable(gradientDrawable, 0, insetTopBy, 0, 0)

    val decisionIcon = tableRow.findViewById<UCImageView>(R.id.ucTableDecisionIcon)
    decisionIcon.setImageDrawable(if (historyEntry.status) context.getYesHistoryIcon() else context.getNoHistoryIcon())
    decisionIcon.styleIcon(theme)

    val decisionText = tableRow.findViewById<UCTextView>(R.id.ucTableDecisionText)
    decisionText.text = historyEntry.decisionText
    decisionText.styleBody(theme)

    val date = tableRow.findViewById<UCTextView>(R.id.ucTableDate)
    date.text = historyEntry.date
    date.styleBody(theme)

    table.addView(tableRow)
}
