package com.usercentrics.sdk.ui.components.cards

import android.content.Context
import android.view.View
import android.view.ViewGroup
import com.usercentrics.sdk.models.settings.PredefinedUIAriaLabels
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.accessibility.accessibleTouchTarget
import com.usercentrics.sdk.ui.components.UCImageView
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.components.UCToggle
import com.usercentrics.sdk.ui.components.drawable.ThemedDrawable.getInfoIcon
import com.usercentrics.sdk.ui.components.drawable.ThemedDrawable.styleIcon
import com.usercentrics.sdk.ui.extensions.inflater
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun buildToggleEntrySectionView(
    context: Context,
    parent: ViewGroup,
    theme: UCThemeData,
    toggleEntryPM: UContentToggleEntryPM,
    onMoreInfo: ((String) -> Unit)?,
    ariaLabels: PredefinedUIAriaLabels,
): View {

    val toggleEntryView = context.inflater.inflate(R.layout.uc_card_section_toggle_entry, parent, false)

    val switch = toggleEntryView.findViewById<UCToggle>(R.id.ucCardSectionToggleEntrySwitch)
    val textView = toggleEntryView.findViewById<UCTextView>(R.id.ucCardSectionToggleEntryText)
    val infoIcon = toggleEntryView.findViewById<UCImageView>(R.id.ucCardSectionToggleEntryInfo)

    val mainToggle = toggleEntryPM.toggle
    val value = toggleEntryPM.name

    if (mainToggle != null) {
        switch.styleToggle(theme)
        switch.bindLegacy(mainToggle)
        switch.visibility = View.VISIBLE
        switch.contentDescription = value
    } else {
        switch.visibility = View.GONE
    }

    textView.apply {
        text = value
        contentDescription = value
        labelFor = infoIcon.id

        styleSmall(theme)
    }

    val moreInfoVisibility = if (onMoreInfo != null) {
        View.VISIBLE
    } else {
        View.GONE
    }

    infoIcon.apply {
        accessibleTouchTarget()
        visibility = moreInfoVisibility
        contentDescription = "$value ${ariaLabels.serviceInCategoryDetails}"
        setOnClickListener { onMoreInfo?.invoke(toggleEntryPM.id) }

        val icon = context.getInfoIcon()?.also { it.styleIcon(theme) }
        setImageDrawable(icon)
    }
    switch.accessibleTouchTarget()
    return toggleEntryView
}
