package com.usercentrics.sdk.ui.components.cards

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import androidx.annotation.AttrRes
import com.usercentrics.sdk.models.settings.PredefinedUIAriaLabels
import com.usercentrics.sdk.ui.PredefinedUIDependencyManager
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCTogglePM
import com.usercentrics.sdk.ui.components.links.UCLinkPMLegacy
import com.usercentrics.sdk.ui.theme.UCThemeData

internal class UCCardSections : LinearLayout {

    private val cardDefaultMargin by lazy {
        context.resources.getDimension(R.dimen.ucCardVerticalMargin).toInt()
    }

    private val ariaLabels: PredefinedUIAriaLabels by lazy { PredefinedUIDependencyManager.ariaLabels }

    private var secionViewContainer: View? = null

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, @AttrRes defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        initView()
    }

    private fun initView() {
        this.orientation = VERTICAL
        this.layoutParams = LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT)
    }

    fun bind(theme: UCThemeData, sections: List<UCContentSectionPM>, onMoreInfo: ((String) -> Unit)?) {
        this.removeAllViews()
        for (model in sections) {
            addSection(theme, model, onMoreInfo)
        }
    }

    private fun addSection(theme: UCThemeData, section: UCContentSectionPM, onMoreInfo: ((String) -> Unit)?) {
        val view = when (section) {
            is UContentToggleEntryPM -> {
                val toggleView = buildToggleEntrySectionView(context, this, theme, section, onMoreInfo, ariaLabels)
                toggleView
            }
            is UCContentTextSectionPM -> buildTextSectionView(context, this, theme, section)
            is UCContentHistorySectionPM -> buildHistorySectionView(context, this, theme, section)
        }

        (view.layoutParams as LayoutParams).apply {
            bottomMargin = cardDefaultMargin
            leftMargin = cardDefaultMargin
            rightMargin = cardDefaultMargin
        }

        this.addView(view)
        secionViewContainer = view
    }
}

internal sealed class UCContentSectionPM

internal class UContentToggleEntryPM(
    val id: String,
    val name: String,
    val toggle: UCTogglePM?
) : UCContentSectionPM()

internal class UCContentTextSectionPM(
    val title: String? = null,
    val description: String? = null,
    val link: UCLinkPMLegacy? = null,
    val tags: List<String> = emptyList()
) : UCContentSectionPM()

internal class UCContentHistorySectionPM(
    val title: String,
    val history: List<UCCardHistoryEntryPM>,
    val decisionLabel: String,
    val dateLabel: String
) : UCContentSectionPM()

internal class UCCardHistoryEntryPM(
    val status: Boolean,
    val date: String,
    val decisionText: String
)
