package com.usercentrics.sdk.ui.components.cookie

import android.graphics.Color
import android.graphics.drawable.GradientDrawable
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.extensions.dpToPx
import com.usercentrics.sdk.ui.extensions.inflate
import com.usercentrics.sdk.ui.theme.UCThemeData

internal class CookieInformationAdapter(
    private val theme: UCThemeData,
    private val data: List<PredefinedUIDeviceStorageContent>
) : RecyclerView.Adapter<CookieInformationAdapter.CookieViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) =
        CookieViewHolder(theme, parent.inflate(R.layout.uc_cookie_card))

    override fun getItemCount() = data.size

    override fun onBindViewHolder(holder: CookieViewHolder, position: Int) {
        val itemData = data[position]
        holder.bindHolder(itemData)
    }

    internal class CookieViewHolder(theme: UCThemeData, itemView: View) : RecyclerView.ViewHolder(itemView) {

        private val ucCookieCardTitle: UCTextView by lazy { itemView.findViewById(R.id.ucCookieCardTitle) }
        private val ucCookieCardTitleDivider: View by lazy { itemView.findViewById(R.id.ucCookieCardTitleDivider) }
        private val ucCardContent: UCTextView by lazy { itemView.findViewById(R.id.ucCardContent) }

        init {
            ucCookieCardTitle.styleSmall(theme)
            ucCardContent.styleSmall(theme)
            theme.colorPalette.layerBackgroundColor?.let { ucCookieCardTitle.setBackgroundColor(it) }

            itemView.background = GradientDrawable().apply {
                shape = GradientDrawable.RECTANGLE
                setColor(theme.colorPalette.layerBackgroundColor ?: Color.WHITE)
                setStroke(1.dpToPx(itemView.context), theme.colorPalette.tabsBorderColor)
            }
            ucCookieCardTitleDivider.setBackgroundColor(theme.colorPalette.tabsBorderColor)
        }

        fun bindHolder(itemData: PredefinedUIDeviceStorageContent) {
            ucCookieCardTitle.text = itemData.title
            ucCardContent.text = itemData.content.joinToString("\n")
        }
    }
}
