package com.usercentrics.sdk.ui.components.cookie

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.app.AlertDialog
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationButtonInfo
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.extensions.themed
import com.usercentrics.sdk.ui.theme.UCThemeData

internal class UCCookiesDialog(
    private val theme: UCThemeData,
    private val storageInformation: PredefinedUIStorageInformationButtonInfo
) {
    private var dialog: AlertDialog? = null

    fun show(context: Context) {
        val cookiesViewModel = UCCookiesViewModelImpl(storageInformation, ::dismissDialog)
        val cookiesView = UCCookiesView(context.themed(), theme, cookiesViewModel)
        dialog = createDialog(context, cookiesView)
    }

    private fun createDialog(context: Context, view: View): AlertDialog {
        return AlertDialog.Builder(context, R.style.DialogBaseTheme).run {
            setCancelable(true)
            setView(view)
            create()
            show()
        }.also {
            it.window?.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        }
    }

    private fun dismissDialog() {
        dialog?.dismiss()
        dialog = null
    }

}
