package com.usercentrics.sdk.ui.components.drawable

import android.content.Context
import android.graphics.PorterDuff
import android.graphics.PorterDuffColorFilter
import android.graphics.drawable.Drawable
import androidx.annotation.DrawableRes
import androidx.appcompat.content.res.AppCompatResources
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.theme.UCThemeData

internal object ThemedDrawable {

    fun Context.getCopyControllerIdIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_copy)
    fun Context.getCheckOutlinedCircleIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_check_circle_outline)
    fun Context.getInfoIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_info)
    fun Context.getExpandIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_expand)
    fun Context.getBackButtonIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_arrow_back)
    fun Context.getCloseIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_close)
    fun Context.getYesHistoryIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_yes)
    fun Context.getNoHistoryIcon(): Drawable? = getCompatDrawable(R.drawable.uc_ic_no)

    private fun Context.getCompatDrawable(@DrawableRes resId: Int): Drawable? = AppCompatResources.getDrawable(this, resId)

    fun Drawable.styleIcon(theme: UCThemeData) {
        theme.colorPalette.text80?.let {
            colorFilter = PorterDuffColorFilter(it, PorterDuff.Mode.SRC_IN)
        }
    }

}
