package com.usercentrics.sdk.ui.firstLayer

import android.graphics.Typeface
import com.usercentrics.sdk.HeaderImageSettings
import com.usercentrics.sdk.SectionAlignment
import com.usercentrics.sdk.models.settings.PredefinedUIAriaLabels
import com.usercentrics.sdk.models.settings.PredefinedUIHtmlLinkType
import com.usercentrics.sdk.models.settings.PredefinedUILink
import com.usercentrics.sdk.ui.components.UCButtonSettings
import com.usercentrics.sdk.ui.secondLayer.UCBaseLayerViewModel
import com.usercentrics.sdk.ui.secondLayer.UCCardsContentPM

internal interface UCFirstLayerViewModel : UCBaseLayerViewModel {

    val closeLink: String?
    val closeIcon: Boolean
    val headerImage: HeaderImageSettings?
    val title: UCFirstLayerTitle?
    val message: UCFirstLayerMessage
    val legalLinks: List<PredefinedUILink>?
    val content: List<UCCardsContentPM>?
    val useAllAvailableVerticalSpace: Boolean
    val ccpaToggle: UCFirstLayerCCPAToggle?
    val buttons: List<List<UCButtonSettings>>
    val poweredByLabel: String?
    val ariaLabels: PredefinedUIAriaLabels

    val shortDescription: String?
    val readMore: String?

    fun onHtmlLinkClick(type: PredefinedUIHtmlLinkType)
    fun onCCPAToggleChanged(state: Boolean)
    fun onLegalLinkClick(link: PredefinedUILink)
    fun onReadMoreClick()
}

internal fun UCFirstLayerViewModel.isCloseAfterHeaderImage(): Boolean = headerImage is HeaderImageSettings.ExtendedLogoSettings

internal data class UCFirstLayerTitle(
    val text: String,
    val customFont: Typeface? = null,
    val customTextSizeInSp: Float? = null,
    val customTextColor: Int? = null,
    val customAlignment: SectionAlignment? = null
)

internal data class UCFirstLayerMessage(
    val text: String,
    val customFont: Typeface? = null,
    val customTextSizeInSp: Float? = null,
    val customAlignment: SectionAlignment? = null,
    val customTextColor: Int? = null,
    val customLinkTextColor: Int? = null,
    val customUnderlineLink: Boolean? = null
)


internal data class UCFirstLayerCCPAToggle(
    val label: String,
    val initialValue: Boolean
)

