package com.usercentrics.sdk.ui.firstLayer.component

import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCSectionTitle
import com.usercentrics.sdk.ui.components.cards.*
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun LinearLayoutCompat.addContent(
    cardsVerticalMargin: Int,
    theme: UCThemeData,
    viewModel: UCFirstLayerViewModel,
    onExpandedCardListener: UCCardExpandedListener
) {
    val innerPadding = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)
    val content = viewModel.content ?: return
    val components = UCCardComponent.from(content)
    components.forEachIndexed { index, component ->
        when (component) {
            is UCSectionTitlePM -> addTitle(theme, innerPadding, cardsVerticalMargin, component)
            is UCCardPM -> addCard(
                theme = theme,
                horizontalMargin = innerPadding,
                verticalMargin = cardsVerticalMargin,
                onExpandedCardListener = onExpandedCardListener,
                isTheLastOne = index == components.lastIndex,
                card = component
            )
            is UCControllerIdPM -> {
                // Do nothing
            }
        }
    }
}

private fun LinearLayoutCompat.addTitle(
    theme: UCThemeData,
    horizontalMargin: Int,
    verticalMargin: Int,
    title: UCSectionTitlePM
) {
    val titleView = UCSectionTitle(context).apply {
        setPaddingRelative(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin)
        style(theme)
        bind(title)
    }

    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT)
    addView(titleView, layoutParams)
}

private fun LinearLayoutCompat.addCard(
    theme: UCThemeData,
    horizontalMargin: Int,
    verticalMargin: Int,
    onExpandedCardListener: UCCardExpandedListener,
    isTheLastOne: Boolean,
    card: UCCardPM,
) {
    val cardView = UCCard(context).apply {
        style(theme)
        bindCard(
            theme = theme,
            model = card,
            isExpanded = false, // Initial state
            onExpandHandler = null,
            onMoreInfo = null,
        )
        onExpandedListener = onExpandedCardListener
    }

    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
        val bottom = if (isTheLastOne) horizontalMargin else verticalMargin
        marginStart = horizontalMargin
        marginEnd = horizontalMargin
        topMargin = verticalMargin
        bottomMargin = bottom
    }
    addView(cardView, layoutParams)
}
