package com.usercentrics.sdk.ui.firstLayer.component

import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.models.settings.PredefinedUILink
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.accessibility.accessibleTouchTarget
import com.usercentrics.sdk.ui.accessibility.createAccessibilityLinkOrButton
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.components.links.LinksViewBuilder
import com.usercentrics.sdk.ui.extensions.setVerticalPadding
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun LinearLayoutCompat.addLinks(theme: UCThemeData, viewModel: UCFirstLayerViewModel) {
    val legalLinks = viewModel.legalLinks ?: return

    val linksVerticalPadding = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLinksVerticalPadding)
    val linksHorizontalSpacing = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLinksHorizontalSpacing)

    val links = legalLinks.map { link -> createLinkView(link, linksVerticalPadding, theme, viewModel) }

    val container = LinksViewBuilder.createLinksLayout(context, links, linksHorizontalSpacing)
    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
        val horizontalMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)

        marginStart = horizontalMargin
        topMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLinksTopMargin)
        marginEnd = horizontalMargin
        bottomMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerLinksBottomMargin)
    }

    addView(container, layoutParams)
}

private fun LinearLayoutCompat.createLinkView(link: PredefinedUILink, linksVerticalPadding: Int, theme: UCThemeData, viewModel: UCFirstLayerViewModel): UCTextView {
    return UCTextView(context).apply {
        text = link.label
        setVerticalPadding(linksVerticalPadding)
        styleSmall(theme, isBold = true, isLink = true)
        setOnClickListener { viewModel.onLegalLinkClick(link) }
        viewModel.message.customLinkTextColor?.let { setTextColor(it) }
        createAccessibilityLinkOrButton()
    }
}
