package com.usercentrics.sdk.ui.firstLayer.component

import android.view.Gravity
import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun LinearLayoutCompat.addPoweredBy(theme: UCThemeData, viewModel: UCFirstLayerViewModel) {
    val poweredByLabel = viewModel.poweredByLabel
    if (poweredByLabel.isNullOrBlank()) {
        return
    }

    val poweredByView = UCTextView(context).apply {
        text = poweredByLabel
        gravity = Gravity.CENTER
        styleTiny(theme)
    }
    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
        val horizontalMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)

        marginStart = horizontalMargin
        topMargin = 0
        marginEnd = horizontalMargin
        bottomMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerPoweredByVerticalMargin)
    }
    this.addView(poweredByView, layoutParams)
}
