package com.usercentrics.sdk.ui.firstLayer.component

import android.os.Build
import android.util.TypedValue
import android.view.View
import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.SectionAlignment.Companion.toGravity
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerTitle
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun LinearLayoutCompat.addTitle(theme: UCThemeData, settings: UCFirstLayerTitle?) {
    val title = settings ?: return
    val titleView = UCTextView(context).apply {
        text = title.text
        styleTitle(theme)
    }
    title.customAlignment?.let {
        titleView.gravity = it.toGravity()
    }
    title.customFont?.let {
        titleView.typeface = it
    }
    title.customTextColor?.let {
        titleView.setTextColor(it)
    }
    title.customTextSizeInSp?.let {
        titleView.setTextSize(TypedValue.COMPLEX_UNIT_SP, it)
    }
    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
        val horizontalMargins = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)

        marginStart = horizontalMargins
        topMargin = 0
        marginEnd = horizontalMargins
        bottomMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerTitleBottomMargin)
    }

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
        titleView.isAccessibilityHeading = true
    } else {
        titleView.importantForAccessibility = View.IMPORTANT_FOR_ACCESSIBILITY_YES
    }

    addView(titleView, layoutParams)
}
