package com.usercentrics.sdk.ui.secondLayer.component.footer

import com.usercentrics.sdk.ButtonLayout
import com.usercentrics.sdk.models.settings.FirstLayerButtonLabels
import com.usercentrics.sdk.models.settings.PredefinedUIFooterButton
import com.usercentrics.sdk.models.settings.PredefinedUIFooterSettings
import com.usercentrics.sdk.ui.components.UCButtonSettings
import com.usercentrics.sdk.ui.components.UCButtonType
import com.usercentrics.sdk.ui.secondLayer.UCSecondLayerViewModel
import com.usercentrics.sdk.ui.theme.UCThemeData

internal interface UCSecondLayerFooterViewModel {
    val buttons: List<List<UCButtonSettings>>
    val optOutToggle: String?
    val optOutToggleInitialValue: Boolean
    val poweredBy: String?

    fun onButtonClick(type: UCButtonType)
    fun onOptOutSwitchChanged(state: Boolean)
}

internal class UCSecondLayerFooterViewModelImpl(
    private val settings: PredefinedUIFooterSettings,
    private val landscapeMode: Boolean,
    private val buttonLayout: ButtonLayout?,
    private val buttonLabels: FirstLayerButtonLabels,
    private val theme: UCThemeData,
    private val parentViewModel: UCSecondLayerViewModel,
) : UCSecondLayerFooterViewModel {

    override val buttons: List<List<UCButtonSettings>> by lazy {
        UCButtonSettings.map(
            isCCPA = optOutToggle != null,
            buttonLayout = buttonLayout,
            defaultButtons = defaultButtons,
            theme = theme,
            buttonLabels = buttonLabels,
        )
    }

    private val defaultButtons: List<List<PredefinedUIFooterButton>> by lazy {
        if (landscapeMode) settings.buttonsLandscape else settings.buttons
    }

    override val optOutToggle: String?
        get() = settings.optOutToggle?.label

    override val optOutToggleInitialValue: Boolean
        get() = parentViewModel.optOutToggleValue

    override val poweredBy: String?
        get() = settings.poweredBy?.label

    override fun onButtonClick(type: UCButtonType) = parentViewModel.onButtonClick(type)

    override fun onOptOutSwitchChanged(state: Boolean) = parentViewModel.onOptOutSwitchChanged(state)

}
