package com.usercentrics.sdk.ui.secondLayer.component.header

import com.usercentrics.sdk.LegalLinksSettings
import com.usercentrics.sdk.UsercentricsImage
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.ui.components.UCButtonType
import com.usercentrics.sdk.ui.extensions.emptyToNull
import com.usercentrics.sdk.ui.secondLayer.UCSecondLayerViewModel
import com.usercentrics.sdk.v2.settings.data.FirstLayerLogoPosition

internal interface UCSecondLayerHeaderViewModel {

    val title: String
    val contentDescription: String
    val legalLinks: List<PredefinedUILink>?
    val logoPosition: FirstLayerLogoPosition
    val logoImage: UsercentricsImage?
    val showCloseButton: Boolean
    val language: PredefinedUILanguageSettings?
    val ariaLabels: PredefinedUIAriaLabels

    fun onLinkClick(link: PredefinedUILink)
    fun onCloseButton()
    fun onSelectLanguage(selectedLanguage: String)
    fun onPredefinedUIHtmlLinkClick(type: PredefinedUIHtmlLinkType)
}

internal class UCSecondLayerHeaderViewModelImpl(
    private val settings: PredefinedUIHeaderSettings,
    private val linksSettings: LegalLinksSettings,
    private val parentViewModel: UCSecondLayerViewModel
) : UCSecondLayerHeaderViewModel {

    override val title
        get() = settings.title

    override val contentDescription
        get() = settings.contentDescription

    override val legalLinks: List<PredefinedUILink>? by lazy {
        val filterLegalLinks = linksSettings == LegalLinksSettings.FIRST_LAYER_ONLY || linksSettings == LegalLinksSettings.HIDDEN
        settings.links.filterNot {
            filterLegalLinks && it.linkType == PredefinedUILinkType.URL
        }.emptyToNull()
    }

    override val logoPosition: FirstLayerLogoPosition
        get() = settings.logoPosition

    override val logoImage: UsercentricsImage? by lazy {
        parentViewModel.customLogo ?: getLogoFromUrl(settings.logoURL)
    }

    private fun getLogoFromUrl(logoUrl: String?): UsercentricsImage? {
        return if (logoUrl?.isNotBlank() == true) {
            UsercentricsImage.ImageUrl(logoUrl)
        } else {
            null
        }
    }

    override val showCloseButton: Boolean
        get() = parentViewModel.showCloseButton

    override val language: PredefinedUILanguageSettings?
        get() = settings.language

    override val ariaLabels: PredefinedUIAriaLabels
        get() = parentViewModel.labels.ariaLabels

    override fun onCloseButton() {
        parentViewModel.onClosePressed()
    }

    override fun onLinkClick(link: PredefinedUILink) {
        parentViewModel.onLinkClick(link)
    }

    override fun onSelectLanguage(selectedLanguage: String) = parentViewModel.onSelectLanguage(selectedLanguage)

    override fun onPredefinedUIHtmlLinkClick(type: PredefinedUIHtmlLinkType) {
        when (type) {
            PredefinedUIHtmlLinkType.ACCEPT_ALL_LINK -> parentViewModel.onButtonClick(UCButtonType.ACCEPT_ALL)
            PredefinedUIHtmlLinkType.DENY_ALL_LINK -> parentViewModel.onButtonClick(UCButtonType.DENY_ALL)
            PredefinedUIHtmlLinkType.SHOW_SECOND_LAYER -> parentViewModel.onButtonClick(UCButtonType.MORE)
        }
    }

}
