package com.usercentrics.sdk.ui.theme

import androidx.annotation.ColorInt
import com.usercentrics.sdk.GeneralStyleSettings
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColor
import com.usercentrics.sdk.ui.color.PredefinedUIColorMachine
import com.usercentrics.sdk.ui.extensions.colorToHexWithNoAlpha
import com.usercentrics.sdk.ui.extensions.parseColor
import com.usercentrics.sdk.ui.extensions.withAlpha

data class UCColorPalette(
    @ColorInt val text100: Int?,
    @ColorInt val text80: Int?,
    @ColorInt val text16: Int?,
    @ColorInt val text2: Int?,

    @ColorInt val layerBackgroundColor: Int?,
    @ColorInt val layerBackgroundSecondaryColor: Int?,
    @ColorInt val selectedTabColor: Int?,
    @ColorInt val linkColor: Int?,

    @ColorInt val overlayColor: Int?,
    @ColorInt val tabsBorderColor: Int,
) {
    // FIXME: a bunch of colors here are impossible to fail the parsing since we're already validating on core
    // maybe we could validate them all instead of delegating the platforms

    companion object {
        fun createFrom(
            customizationColor: PredefinedUICustomizationColor,
            generalStyleSettings: GeneralStyleSettings?,
        ): UCColorPalette {
            val customTextColor = generalStyleSettings?.textColor?.let { PredefinedUIColorMachine.generateShadedColor(it.colorToHexWithNoAlpha()) }
            val textColor = customTextColor ?: customizationColor.text

            return UCColorPalette(
                text100 = textColor.color100.parseColor(),
                text80 = textColor.color80.parseColor(),
                text16 = textColor.color16.parseColor(),
                text2 = textColor.color2.parseColor(),

                layerBackgroundColor = generalStyleSettings?.layerBackgroundColor ?: customizationColor.layerBackgroundColor.parseColor(),
                layerBackgroundSecondaryColor = generalStyleSettings?.layerBackgroundSecondaryColor ?: customizationColor.layerBackgroundSecondaryColor.parseColor(),
                selectedTabColor = generalStyleSettings?.tabColor ?: customizationColor.tabColor.parseColor(),
                linkColor = generalStyleSettings?.linkColor ?: customizationColor.linkColor.parseColor(),

                overlayColor = customizationColor.baseOverlayColor.withAlpha(customizationColor.overlayOpacity).parseColor(),
                tabsBorderColor = generalStyleSettings?.bordersColor ?: customizationColor.tabsBorderColor.parseColor()!!
            )
        }
    }
}
