package com.usercentrics.sdk.ui.theme

import androidx.annotation.ColorInt
import com.usercentrics.sdk.ToggleStyleSettings
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorToggles
import com.usercentrics.sdk.ui.extensions.parseColor

data class UCToggleTheme(
    @ColorInt val activeBackground: Int,
    @ColorInt val inactiveBackground: Int,
    @ColorInt val disabledBackground: Int,
    @ColorInt val activeIcon: Int,
    @ColorInt val inactiveIcon: Int,
    @ColorInt val disabledIcon: Int
) {
    companion object {
        val stateDisabledAndNotChecked: IntArray =
            intArrayOf(-android.R.attr.state_enabled, -android.R.attr.state_checked)
        val stateDisabledAndChecked: IntArray =
            intArrayOf(-android.R.attr.state_enabled, android.R.attr.state_checked)
        val stateEnabledAndChecked: IntArray =
            intArrayOf(android.R.attr.state_enabled, android.R.attr.state_checked)
        val stateEnabledAndNotChecked: IntArray =
            intArrayOf(android.R.attr.state_enabled, -android.R.attr.state_checked)

        fun create(
            toggleCustomizationColor: PredefinedUICustomizationColorToggles,
            toggleStyleSettings: ToggleStyleSettings?,
        ): UCToggleTheme? {
            return runCatching {
                UCToggleTheme(
                    activeBackground = toggleStyleSettings?.activeBackgroundColor ?: toggleCustomizationColor.activeBackground.parseColor()!!,
                    inactiveBackground = toggleStyleSettings?.inactiveBackgroundColor ?: toggleCustomizationColor.inactiveBackground.parseColor()!!,
                    disabledBackground = toggleStyleSettings?.disabledBackgroundColor ?: toggleCustomizationColor.disabledBackground.parseColor()!!,
                    activeIcon = toggleStyleSettings?.activeThumbColor ?: toggleCustomizationColor.activeIcon.parseColor()!!,
                    inactiveIcon = toggleStyleSettings?.inactiveThumbColor ?: toggleCustomizationColor.inactiveIcon.parseColor()!!,
                    disabledIcon = toggleStyleSettings?.disabledThumbColor ?: toggleCustomizationColor.disabledIcon.parseColor()!!,
                )
            }.getOrNull()
        }
    }
}
