package com.usercentrics.sdk.ui.toggle

import com.usercentrics.sdk.ui.extensions.addIfAbsent
import kotlin.properties.Delegates

interface PredefinedUIToggleGroup : PredefinedUIAbstractToggle {
    fun bind(toggle: PredefinedUIAbstractToggle)
    fun unbind(toggle: PredefinedUIAbstractToggle)
}

class PredefinedUIToggleGroupImpl(currentState: Boolean) : PredefinedUIToggleGroup {

    private var listener: (Boolean) -> Unit = {}
    private var toggles: MutableList<PredefinedUIAbstractToggle> = mutableListOf()

    override var currentState: Boolean by Delegates.observable(currentState) { _, oldValue, newValue ->
        if (oldValue != newValue) {
            for (toggle in toggles) {
                if (toggle.currentState != newValue) {
                    toggle.currentState = newValue
                }
            }
        }
    }

    override fun bind(toggle: PredefinedUIAbstractToggle) {
        val added = toggles.addIfAbsent(toggle)
        if (added) {
            if (currentState != toggle.currentState) {
                toggle.currentState = currentState
            }
            toggle.setListener(::onStateChange)
        }
    }

    // Public for testing purposes
    fun onStateChange(newState: Boolean) {
        currentState = newState
        listener(newState)
    }

    override fun unbind(toggle: PredefinedUIAbstractToggle) {
        toggle.setListener(null)
        toggles.remove(toggle)
    }

    override fun setListener(listener: ((Boolean) -> Unit)?) {
        this.listener = listener ?: {}
    }

    override fun dispose() {
        for (toggle in toggles) {
            toggle.dispose()
        }
        toggles.clear()
        listener = {}
    }
}
