package com.usercentrics.sdk

import java.util.*

internal actual typealias UsercentricsLocale = Locale

internal actual class DeviceLanguage {
    actual fun deviceLocale(): UsercentricsLocale = Locale.getDefault()

    actual fun matchLanguage(targetLocale: UsercentricsLocale, availableLanguages: List<String>): String? {
        // Match using region
        val match = availableLanguages.find {
            val languageLocale = getLanguageLocale(it)
            targetLocale.language == languageLocale.language &&
                    targetLocale.country == languageLocale.country
        }
        if (match != null) return match

        // Match without region
        return availableLanguages.find {
            val languageLocale = getLanguageLocale(it)
            targetLocale.language == languageLocale.language
        }
    }

    private fun getLanguageLocale(fullLanguageCode: String): Locale {
        return fullLanguageCode.split(platformLanguageIsoSeparator).let {
            Locale(it.getOrNull(0) ?: "", it.getOrNull(1) ?: "")
        }
    }

    actual fun getFullLanguageName(isoCode: String): String {
        val locale = getLanguageLocale(isoCode)
        return locale.getDisplayName(locale).replaceFirstChar { if (it.isLowerCase()) it.titlecase(locale) else it.toString() }
    }
}

