package com.usercentrics.sdk

import android.os.Looper

internal actual inline fun assert(value: Boolean, lazyMessage: () -> Any) = kotlin.assert(value, lazyMessage)

internal actual fun assertUIThread() {
    if (isUnitTest()) return
    assert(isUIThread()) { "UI thread execution is required" }
}

internal actual fun assertNotUIThread() {
    if (isUnitTest()) return
    assert(!isUIThread()) { "UI thread execution is not allowed" }
}

private fun isUIThread(): Boolean = Looper.getMainLooper()?.thread == Thread.currentThread()
private fun isUnitTest(): Boolean = Looper.getMainLooper() == null
