package com.usercentrics.sdk

import android.text.Spanned
import androidx.core.text.HtmlCompat
import com.usercentrics.sdk.v2.settings.data.UsercentricsLabels
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings

val UsercentricsSettings.firstLayerDescription: Spanned
    get() = spannedString(this.firstLayerDescriptionHtml)

val UsercentricsSettings.firstLayerMobileDescription: Spanned
    get() = spannedString(this.firstLayerMobileDescriptionHtml)

val UsercentricsLabels.secondLayerDescription: Spanned
    get() = spannedString(this.secondLayerDescriptionHtml)

private fun spannedString(input: String?) = HtmlCompat.fromHtml(input ?: "", HtmlCompat.FROM_HTML_MODE_LEGACY)
