package com.usercentrics.sdk.core.hash

import java.security.MessageDigest

internal actual object SHA256 {

    actual fun digest(input: String): String {
        val messageDigest = MessageDigest.getInstance("SHA-256")
        val digest = messageDigest.digest(input.toByteArray())
        return digest.fold("", { str, it -> str + "%02x".format(it) })
    }
}
