package com.usercentrics.sdk.lifecycle

import java.util.*

internal class AndroidLifecycleListener constructor(
    private val intervalInMillis: Long,
    private val lifecycleListenerCallback: LifecycleListenerCallback,
) : ApplicationLifecycleListener {

    private var timer: Timer? = null

    override fun setup() {
        assert(timer == null)

        lifecycleListenerCallback.invoke()

        timer = Timer(true).apply {
            scheduleAtFixedRate(object : TimerTask() {
                override fun run() {
                    lifecycleListenerCallback.invoke()
                }
            }, /* delay = */ intervalInMillis, /* period = */ intervalInMillis)
        }
    }

    override fun tearDown() {
        timer?.cancel()
        timer = null
    }
}
