package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.MediationGranularConsent

internal actual class AdjustSDK actual constructor(
    override val logger: UsercentricsLogger
) : AdjustSDKInterface(logger) {

    override fun addPartnerSharingSetting(partner: String, consent: Boolean): Boolean {
        try {
            Class.forName("com.adjust.sdk.AdjustThirdPartySharing")

            val adjustThirdPartySharing = com.adjust.sdk.AdjustThirdPartySharing(null).apply {
                addPartnerSharingSetting(partner, "install", consent)
                addPartnerSharingSetting(partner, "events", consent)
                addPartnerSharingSetting(partner, "sessions", consent)
            }
            com.adjust.sdk.Adjust.trackThirdPartySharing(adjustThirdPartySharing)

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    override fun addAdjustGeneralConsent(consent: Boolean): Boolean {
        try {
            Class.forName("com.adjust.sdk.Adjust")

            com.adjust.sdk.Adjust.trackMeasurementConsent(consent)
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    override fun signalGooglePartnerFlags(granularConsent: MediationGranularConsent): Boolean {
        try {
            Class.forName("com.adjust.sdk.AdjustThirdPartySharing")

            val partnerName = "google_dma"
            val dmaThirdPartySharing = com.adjust.sdk.AdjustThirdPartySharing(null).apply {
                addGranularOption(partnerName, "eea", booleanToString(granularConsent.eea))
                addGranularOption(partnerName, "ad_personalization", booleanToString(granularConsent.adPersonalization))
                addGranularOption(partnerName, "ad_user_data", booleanToString(granularConsent.adUserData))
            }
            com.adjust.sdk.Adjust.trackThirdPartySharing(dmaThirdPartySharing)

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
