package com.usercentrics.sdk.mediation.sdk


import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class AirBridgeMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("co.ab180.airbridge.Airbridge")

            if (consent) {
                co.ab180.airbridge.Airbridge.startTracking()
            } else {
                co.ab180.airbridge.Airbridge.stopTracking()
            }

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
