package com.usercentrics.sdk.mediation.sdk

import com.appsflyer.AppsFlyerConsent
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class AppsFlyerMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.appsflyer.AppsFlyerLib")

            when (variant) {
                UsercentricsVariant.TCF -> {
                    com.appsflyer.AppsFlyerLib.getInstance().enableTCFDataCollection(true)
                }

                UsercentricsVariant.DEFAULT -> {
                    val gdprUser = AppsFlyerConsent(
                        isUserSubjectToGDPR = true,
                        hasConsentForDataUsage = consent,
                        hasConsentForAdsPersonalization = consent,
                        hasConsentForAdStorage = consent
                    )

                    com.appsflyer.AppsFlyerLib.getInstance().setConsentData(gdprUser)
                }

                UsercentricsVariant.CCPA -> {
                    val nonGdprUser = AppsFlyerConsent(
                        isUserSubjectToGDPR = false,
                        hasConsentForDataUsage = consent,
                        hasConsentForAdsPersonalization = consent,
                        hasConsentForAdStorage = consent
                    )

                    com.appsflyer.AppsFlyerLib.getInstance().setConsentData(nonGdprUser)
                }
            }

            return true

        } catch (ex: Exception) {
            logException(ex)
        }

        return false
    }
}

