package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class ChartboostMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
    val context: UsercentricsContext?,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.chartboost.sdk.Chartboost")

            val context = context!!

            if (variant == UsercentricsVariant.CCPA) {
                applyCCPAConsent(consent, context)
            } else {
                applyGDPRConsent(consent, context)
                applyLGPDConsent(consent, context)
            }
            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    private fun applyCCPAConsent(consent: Boolean, context: UsercentricsContext) {
        val actualConsentValue = if (consent) com.chartboost.sdk.privacy.model.CCPA.CCPA_CONSENT.OPT_IN_SALE else com.chartboost.sdk.privacy.model.CCPA.CCPA_CONSENT.OPT_OUT_SALE
        com.chartboost.sdk.Chartboost.addDataUseConsent(context, com.chartboost.sdk.privacy.model.CCPA(actualConsentValue))
    }

    private fun applyGDPRConsent(consent: Boolean, context: UsercentricsContext) {
        val actualConsentValue = if (consent) com.chartboost.sdk.privacy.model.GDPR.GDPR_CONSENT.BEHAVIORAL else com.chartboost.sdk.privacy.model.GDPR.GDPR_CONSENT.NON_BEHAVIORAL
        com.chartboost.sdk.Chartboost.addDataUseConsent(context, com.chartboost.sdk.privacy.model.GDPR(actualConsentValue))
    }

    private fun applyLGPDConsent(consent: Boolean, context: UsercentricsContext) {
        com.chartboost.sdk.Chartboost.addDataUseConsent(context, com.chartboost.sdk.privacy.model.LGPD(consent))
    }
}
