package com.usercentrics.sdk.mediation.sdk

import com.google.firebase.analytics.FirebaseAnalytics
import com.google.firebase.analytics.ktx.analytics
import com.google.firebase.ktx.Firebase
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.mediation.data.MediationGranularConsent
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class FirebaseAnalyticsMediationSDK actual constructor(
    override val name: String,
    override val vendorId: Int,
    override val logger: UsercentricsLogger,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics")

            Firebase.analytics.apply {
                setConsent(mapOf(FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE to consentStatus(consent)))
                setAnalyticsCollectionEnabled(consent)
            }

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    override fun applyGranular(granularConsent: MediationGranularConsent): Boolean {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics")

            Firebase.analytics.setConsent(
                mapOf(
                    FirebaseAnalytics.ConsentType.AD_STORAGE to consentStatus(granularConsent.adStorage),
                    FirebaseAnalytics.ConsentType.AD_PERSONALIZATION to consentStatus(granularConsent.adPersonalization),
                    FirebaseAnalytics.ConsentType.AD_USER_DATA to consentStatus(granularConsent.adUserData),
                    FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE to consentStatus(granularConsent.analyticsStorage)
                )
            )
            Firebase.analytics.setAnalyticsCollectionEnabled(granularConsent.analyticsStorage)

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }

    private fun consentStatus(consent: Boolean): FirebaseAnalytics.ConsentStatus {
        return if (consent) {
            FirebaseAnalytics.ConsentStatus.GRANTED
        } else {
            FirebaseAnalytics.ConsentStatus.DENIED
        }
    }
}
