package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.MediationSDK
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal actual class UnityAdsMediationSDK actual constructor(
    override val name: String,
    override val logger: UsercentricsLogger,
    val context: UsercentricsContext?,
) : MediationSDK(name, logger) {

    override fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean {
        try {
            Class.forName("com.unity3d.ads.metadata.MetaData")

            val gdprMetaData = com.unity3d.ads.metadata.MetaData(context)

            val key = if (variant == UsercentricsVariant.CCPA) {
                "privacy.consent"
            } else {
                "gdpr.consent"
            }

            gdprMetaData.set(key, consent)

            gdprMetaData.commit()

            return true
        } catch (ex: Exception) {
            logException(ex)
        }
        return false
    }
}
