package com.usercentrics.sdk.services.deviceStorage

import android.content.Context
import android.content.SharedPreferences
import com.usercentrics.sdk.UsercentricsContext

internal actual class KeyValueStorageProvider actual constructor(
    private val context: UsercentricsContext?
) {
    actual fun provideDefault(): KeyValueStorage {
        return SharedPreferencesKeyValueStorage(defaultSharedPreferences())
    }

    actual fun provideCustom(name: String): KeyValueStorage {
        return SharedPreferencesKeyValueStorage(customSharedPreferences(name))
    }

    private fun defaultSharedPreferences(): SharedPreferences {
        return context!!.getSharedPreferences(getDefaultSharedPreferencesName(), Context.MODE_PRIVATE)
    }

    private fun getDefaultSharedPreferencesName(): String = "${context!!.packageName}_preferences"

    private fun customSharedPreferences(name: String): SharedPreferences {
        return context!!.getSharedPreferences(name, Context.MODE_PRIVATE)
    }
}
