package com.usercentrics.sdk.unity.provider

import java.lang.reflect.Method

internal class UnityMessageSenderImpl : UnityMessageSender {

    private val unityPlayerClassName = "com.unity3d.player.UnityPlayer"
    private val unityPlayerSendMessageMethod = "UnitySendMessage"

    private val sendMessageMethod: Method by lazy {
        val playerClass = Class.forName(unityPlayerClassName)
        playerClass.getMethod(
            unityPlayerSendMessageMethod,
            String::class.java,
            String::class.java,
            String::class.java
        )
    }

    override fun sendUnityMessage(gameObjectName: String, receiver: String, content: String) {
        sendMessageMethod.invoke(null, gameObjectName, receiver, content)
    }
}
