package com.usercentrics.sdk.v2.file

import com.usercentrics.sdk.v2.file.IFileStorage.Companion.baseDirectoryName
import java.io.File

internal class AndroidFileStorage(rootDirectory: File) : IFileStorage {
    private val baseDirectory by lazy {
        File(rootDirectory, baseDirectoryName).apply {
            mkdirs()
        }
    }

    override fun getFile(fileRelativePath: String): String? = runCatching {
        File(baseDirectory, fileRelativePath).readText()
    }.getOrNull()

    override fun storeFile(fileRelativePath: String, fileContent: String) {
        runCatching { File(baseDirectory, fileRelativePath).writeText(fileContent) }
    }

    override fun mkdir(relativePath: String) {
        File(baseDirectory, relativePath).mkdirs()
    }

    override fun rm(relativePath: String) {
        File(baseDirectory, relativePath).delete()
    }

    override fun ls(relativePath: String): List<String> {
        return File(baseDirectory, relativePath).list()?.toList() ?: emptyList()
    }

    override fun rmdir(relativePath: String) {
        File(baseDirectory, relativePath).deleteRecursively()
    }

    override fun copy(fromRelativePath: String, toRelativePath: String) {
        val file = File(baseDirectory, fromRelativePath)
        if (file.exists()) {
            file.copyRecursively(File(baseDirectory, toRelativePath), overwrite = true)
        }
    }

    override fun rmAll() {
        baseDirectory.deleteRecursively()
    }
}

