package com.usercentrics.ccpa

internal class CCPAException(message: String, cause: Throwable? = null) : Exception(message, cause) {
    companion object {
        fun invalidVersion(supportedApiVersion: Int, incomingVersion: Int) =
            CCPAException("Invalid CCPA API version, supported=$supportedApiVersion, incoming=$incomingVersion")

        fun parseString(ccpaString: String, cause: Throwable? = null) =
            CCPAException("Cannot parse the CCPA String: $ccpaString", cause)

        fun invalidString(ccpaString: String) =
            CCPAException("Invalid CCPA String: $ccpaString")
    }
}

