package com.usercentrics.ccpa

/**
 * This interface should store the values on NSUserDefaults (iOS) or SharedPreferences (Android).
 * https://github.com/InteractiveAdvertisingBureau/USPrivacy/blob/master/CCPA/USP%20API.md#in-app-support
 */
internal interface CCPAStorage {

    fun deleteKey(key: String)

    fun getValue(key: String, defaultValue: String?): String?

    fun putValue(key: String, value: String)

}
