package com.usercentrics.ccpa


/**
 * This class is the Kotlin implementation of:
 * usprivacy-string.js
 *
 * Source code:
 * https://github.com/InteractiveAdvertisingBureau/CCPA-reference-code/blob/master/src/usprivacy-string.js
 *
 * The class contains the methods to get/set the usprivacy string
 * and a method to get the current version.
 *
 * The usprivacy string as the format: ”vnol” where
 *  v = version
 *  n = Notice Given
 *  o = OptedOut
 *  l = lspact (Limited Service Provider Agreement Covered Transaction)
 * Example: “1YYY” Version 1, Notice given, Opted out, LSAPCT in place.
 * Default is null.
 *
 **/
internal object CCPAStringValidator {
    private const val version = 1
    private val validStringRegExp = "^[$version][nNyY-][nNyY-][nNyY-]\$".toRegex()

    const val initialValue = "$version---"
    fun isValidString(ccpaString: String) = validStringRegExp.matches(ccpaString)
}
