package com.usercentrics.sdk

import com.usercentrics.sdk.models.common.UsercentricsVariant
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory
import com.usercentrics.sdk.v2.settings.data.UsercentricsService
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

data class UsercentricsCMPData(
    /** The general settings defined for the settingsId. */
    val settings: UsercentricsSettings,
    /** The services defined for the settingsId. */
    val services: List<UsercentricsService>,
    /** The legal basis localizations. */
    val legalBasis: LegalBasisLocalization,
    /** The active variant. */
    val activeVariant: UsercentricsVariant,
    /** The current user location. */
    val userLocation: UsercentricsLocation,
) {
    /** The categories defined for the settingsId. */
    val categories: List<UsercentricsCategory> = settings.categories ?: listOf()
}
