package com.usercentrics.sdk

import com.usercentrics.sdk.core.application.UsercentricsApplication

class UsercentricsDisposableEvent<T>(
    internal var callback: ((T) -> Unit)? = null
) {

    fun dispose() {
        callback = null
    }

    internal fun call(value: T?) {
        if (value == null) {
            return
        }

        UsercentricsApplication.instance?.application?.dispatcher?.dispatchMain {
            callback?.invoke(value)
        }
    }
}
