package com.usercentrics.sdk

import kotlinx.serialization.Serializable

@Serializable
data class UsercentricsDomains(
    val aggregatorCdnUrl: String,
    val cdnUrl: String,
    val analyticsUrl: String,
    val saveConsentsUrl: String,
    val getConsentsUrl: String
) {
    internal fun isValid(): Boolean {
        return urlsAreNotBlank() && doesNotContainUCSuffix()
    }

    private fun urlsAreNotBlank(): Boolean {
        return aggregatorCdnUrl.isNotBlank() &&
                cdnUrl.isNotBlank() &&
                analyticsUrl.isNotBlank() &&
                saveConsentsUrl.isNotBlank() &&
                getConsentsUrl.isNotBlank()
    }

    private fun doesNotContainUCSuffix(): Boolean {
        val suffix = "usercentrics.eu"

        return !(aggregatorCdnUrl.contains(suffix) ||
                cdnUrl.contains(suffix) ||
                analyticsUrl.contains(suffix) ||
                saveConsentsUrl.contains(suffix) ||
                getConsentsUrl.contains(suffix))
    }
}

internal object EmptyUsercentricsDomains {
    operator fun invoke() : UsercentricsDomains {
        return UsercentricsDomains("","","","","")
    }
}
