package com.usercentrics.sdk

import com.usercentrics.sdk.acm.service.AdditionalConsentModeService
import com.usercentrics.sdk.errors.UsercentricsError
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.models.common.UsercentricsVariant
import com.usercentrics.sdk.predefinedUI.PredefinedUIConsentManagerImpl
import com.usercentrics.sdk.services.ccpa.ICcpa
import com.usercentrics.sdk.services.settings.ISettingsLegacy
import com.usercentrics.sdk.services.tcf.TCFUseCase
import com.usercentrics.sdk.ui.PredefinedUIHolder
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher
import com.usercentrics.sdk.v2.banner.model.PredefinedUIViewData
import com.usercentrics.sdk.v2.banner.service.BannerViewDataServiceImpl
import com.usercentrics.sdk.v2.settings.service.ISettingsService
import com.usercentrics.sdk.v2.translation.service.ITranslationService

class PredefinedUIViewHandlers(
    val updateLanguage: (
        newLanguage: String,
        onSuccess: (PredefinedUIViewData) -> Unit,
        onFailure: (UsercentricsError) -> Unit
    ) -> Unit
)

internal class UsercentricsView(
    private val usercentricsSDK: UsercentricsSDK,
    private val variant: UsercentricsVariant,
    private val controllerId: String,
    private val logger: UsercentricsLogger,
    settingsService: ISettingsService,
    translationService: ITranslationService,
    ccpaInstance: ICcpa,
    settingsLegacy: ISettingsLegacy,
    tcfInstance: TCFUseCase,
    additionalConsentModeService: AdditionalConsentModeService,
    dispatcher: Dispatcher
) {

    private val viewDataService = BannerViewDataServiceImpl(
        settingsService = settingsService,
        settingsLegacy = settingsLegacy,
        tcfInstance = tcfInstance,
        ccpaInstance = ccpaInstance,
        additionalConsentModeService = additionalConsentModeService,
        variant = variant,
        translationService = translationService,
        dispatcher = dispatcher,
    )

    private fun invokeChangeLanguage(
        language: String,
        onSuccess: (PredefinedUIViewData) -> Unit,
        onFailure: (UsercentricsError) -> Unit
    ) {
        usercentricsSDK.changeLanguage(
            language,
            onSuccess = {
                viewDataService.buildViewData { viewData ->
                    onSuccess(viewData)
                }
            },
            onFailure = {
                logger.error(it)
                onFailure(it)
            }
        )
    }

    fun getUIHolder(callback: (PredefinedUIHolder) -> Unit) {
        viewDataService.buildViewData { viewData ->
            callback(
                PredefinedUIHolder(
                    viewData,
                    PredefinedUIConsentManagerImpl(usercentricsSDK, variant, controllerId),
                    PredefinedUIViewHandlers(
                        updateLanguage = { language, onSuccess, onFailure -> invokeChangeLanguage(language, onSuccess, onFailure) }
                    )
                ),
            )
        }
    }
}
