package com.usercentrics.sdk.acm.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.services.api.NetworkResolver

internal class AdditionalConsentModeApiImpl(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver,
) : AdditionalConsentModeApi {

    override suspend fun loadAdTechProviderList(headers: Map<String, String>): HttpResponse {
        return restClient.getSync2(buildUrl(), headers)
    }

    private fun buildUrl(): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        return "${baseUrl}/tcfac/acp.json"
    }
}
