package com.usercentrics.sdk.core.application

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.UsercentricsOptions
import com.usercentrics.sdk.domain.api.http.HttpClient
import com.usercentrics.sdk.services.api.http.HttpClientResolver
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher

internal class UsercentricsApplication {

    internal var application: Application? = null
    internal var options: UsercentricsOptions? = null

    private var httpClient: HttpClient? = null
    private var context: UsercentricsContext? = null

    companion object {

        internal var provider: ApplicationProvider? = null
            private set

        internal var instance: UsercentricsApplication? = null
            private set

        fun provide(): Application {
            return instance().provide()
        }

        fun setProvider(provider: ApplicationProvider?) {
            this.provider = provider
            instance?.invalidate(false)
        }

        fun setInitialValues(options: UsercentricsOptions, context: UsercentricsContext?) {
            instance().setInitialValues(options, context)
        }

        fun provideHttpClient(timeoutMillis: Long, dispatcher: Dispatcher): HttpClient {
            return instance().provideHttpClient(timeoutMillis, dispatcher)
        }

        fun tearDown(clearStorage: Boolean) {
            instance?.invalidate(clearStorage)
            instance = null
        }

        internal fun instance(): UsercentricsApplication {
            return instance ?: run {
                val newValue = UsercentricsApplication()
                instance = newValue
                newValue
            }
        }
    }

    private fun provide(): Application {
        return application ?: run {
            val newValue = createApplication()
            application = newValue
            newValue
        }
    }

    private fun createApplication(): Application {
        val provider = provider ?: run {
            val newProvider = MainApplicationProvider()
            provider = newProvider
            newProvider
        }
        return provider.provide(options!!, context)
    }

    private fun setInitialValues(options: UsercentricsOptions, context: UsercentricsContext?) {
        this.context = context

        if (setOptions(options)) {
            invalidate(false)
        }
    }

    private fun setOptions(options: UsercentricsOptions): Boolean {
        if (this.options == options) {
            return false
        }

        val hadPreviousValue = this.options != null
        this.options = options

        return hadPreviousValue
    }

    private fun provideHttpClient(timeoutMillis: Long, dispatcher: Dispatcher): HttpClient {
        return httpClient ?: run {
            val newValue = HttpClientResolver().buildHttpClient(timeoutMillis, dispatcher)
            this.httpClient = newValue
            newValue
        }
    }

    private fun invalidate(clearStorage: Boolean) {
        runCatching { application?.tearDown(clearStorage) }
        application = null
    }
}
