package com.usercentrics.sdk.domain.api.http

internal interface HttpRequests {

    fun get(
        url: String,
        headers: Map<String, String>? = null,
        onSuccess: (HttpResponse) -> Unit,
        onError: (Throwable) -> Unit
    )

    fun post(
        url: String,
        bodyData: String,
        headers: Map<String, String>? = null,
        onSuccess: (String) -> Unit,
        onError: (Throwable) -> Unit
    )

    fun getSync(url: String, headers: Map<String, String>? = null): HttpResponse
    fun postSync(url: String, bodyData: String, headers: Map<String, String>? = null): String

    suspend fun getSync2(url: String, headers: Map<String, String>? = null): HttpResponse
}
