package com.usercentrics.sdk.domain.api.http

import com.usercentrics.sdk.v2.location.data.UsercentricsLocation

// TODO: Use this class also in POST methods
internal data class HttpResponse(
    val headers: Map<String, String> = mapOf(),
    // TODO: Refactor this to be nullable
    val body: String = "",
    val statusCode: Int = 0
) {

    companion object {
        val cacheControlRegex = Regex("""max-age=(\d+)""")
    }

    fun parseLocation(): UsercentricsLocation {
        val locationString = headers["x-client-geo-location"] ?: ""
        val locationParts = locationString.split(",")

        return if (locationParts.isEmpty()) {
            UsercentricsLocation()
        } else {
            UsercentricsLocation(countryCode = locationParts[0], regionCode = locationParts.getOrElse(1) { "" })
        }
    }

    fun parseCacheControl(): Int {
        val cacheControlString = headers["cache-control"]
        val matchResult = cacheControlString?.let { cacheControlRegex.find(it) }
        return matchResult?.groupValues?.get(1)?.toIntOrNull() ?: 0
    }
}
