package com.usercentrics.sdk.errors

import com.usercentrics.sdk.models.api.ApiErrors

internal class InitializationFailedException(
    initializeOnlineError: UsercentricsException,
) : UsercentricsException(
    "Usercentrics initialization failed: ${resolveCause(initializeOnlineError)}"
) {
    companion object {
        private fun resolveCause(initializeOnlineError: UsercentricsException): String {
            return when (initializeOnlineError.message) {
                ApiErrors.FETCH_RULE_SET, ApiErrors.FETCH_AVAILABLE_LANGUAGES -> "Unable to initialise due to poor or no network connection."
                ApiErrors.RULE_SET_NOT_FOUND, ApiErrors.AVAILABLE_LANGUAGES_SETTINGS_NOT_FOUND -> "Unable to initialise due to wrong configuration, please make sure your settingsID/ruleSetID is correct."
                else -> "Something went wrong during the initialisation."
            }
        }
    }
}
